/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TreeNodeModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.ModelUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.ProjectPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.io.Serializable;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class NestedRepositoryTreePanel
extends BasePanel {
    private static final long serialVersionUID = 1L;

    public NestedRepositoryTreePanel(String wicketId, IModel<TreeNodeModel> model, final Map<Constants.AccessRestrictionType, String> accessRestrictionTranslations, final boolean linksActive) {
        super(wicketId);
        final boolean showSize = this.app().settings().getBoolean("web.showRepositorySizes", true);
        final boolean showSwatch = this.app().settings().getBoolean("web.repositoryListSwatches", true);
        final TreeNodeModel node = (TreeNodeModel)model.getObject();
        Fragment nodeHeader = new Fragment("nodeHeader", "groupRepositoryRow", (MarkupContainer)this);
        this.add(new Component[]{nodeHeader});
        WebMarkupContainer firstColumn = new WebMarkupContainer("firstColumn");
        nodeHeader.add(new Component[]{firstColumn});
        RepeatingView depth = new RepeatingView("depth");
        for (int i = 0; i < node.getDepth(); ++i) {
            depth.add(new Component[]{new WebMarkupContainer(depth.newChildId())});
        }
        firstColumn.add(new Component[]{depth});
        firstColumn.add(new Component[]{new Fragment("groupCollapsible", "tableGroupMinusCollapsible", (MarkupContainer)this)});
        if (node.getParent() != null) {
            this.addChildOfNodeIdCssClassesToRow((Component)nodeHeader, node.getParent());
        }
        nodeHeader.add(new IBehavior[]{new AttributeAppender("data-node-id", (IModel)Model.of((Serializable)Integer.valueOf(node.hashCode())), " ")});
        String name = node.getName();
        if (name.startsWith(ModelUtils.getUserRepoPrefix())) {
            String username = ModelUtils.getUserNameFromRepoPath(name);
            UserModel user = this.app().users().getUserModel(username);
            firstColumn.add(new Component[]{new LinkPanel("groupName", null, user == null ? username : user.getDisplayName(), UserPage.class, WicketUtils.newUsernameParameter(username))});
            nodeHeader.add(new Component[]{new Label("groupDescription", this.getString("gb.personalRepositories"))});
        } else {
            firstColumn.add(new Component[]{new LinkPanel("groupName", null, name, ProjectPage.class, WicketUtils.newProjectParameter(name))});
            nodeHeader.add(new Component[]{new Label("groupDescription", "")});
        }
        WicketUtils.addCssClass((Component)nodeHeader, "group collapsible tree");
        this.add(new Component[]{new ListView<RepositoryModel>("repositories", node.getRepositories()){
            private static final long serialVersionUID = 1L;
            int counter;
            {
                super(x0, x1);
                this.counter = 0;
            }

            public boolean isVisible() {
                return super.isVisible() && !node.getRepositories().isEmpty();
            }

            protected void populateItem(ListItem<RepositoryModel> item) {
                RepositoryModel entry = (RepositoryModel)item.getModelObject();
                WebMarkupContainer rowContent = new WebMarkupContainer("rowContent");
                item.add(new Component[]{rowContent});
                NestedRepositoryTreePanel.this.addChildOfNodeIdCssClassesToRow((Component)rowContent, node);
                WebMarkupContainer firstColumn = new WebMarkupContainer("firstColumn");
                rowContent.add(new Component[]{firstColumn});
                RepeatingView depth = new RepeatingView("depth");
                for (int i = 0; i < node.getDepth(); ++i) {
                    depth.add(new Component[]{new WebMarkupContainer(depth.newChildId())});
                }
                firstColumn.add(new Component[]{depth});
                Fragment iconFragment = entry.isMirror ? new Fragment("repoIcon", "mirrorIconFragment", (MarkupContainer)this) : (entry.isFork() ? new Fragment("repoIcon", "forkIconFragment", (MarkupContainer)this) : (entry.isBare ? new Fragment("repoIcon", "repoIconFragment", (MarkupContainer)this) : new Fragment("repoIcon", "cloneIconFragment", (MarkupContainer)this)));
                if (showSwatch) {
                    WicketUtils.setCssStyle((Component)iconFragment, "color:" + StringUtils.getColor(entry.toString()));
                }
                firstColumn.add(new Component[]{iconFragment});
                String repoName = StringUtils.getLastPathElement(entry.toString());
                if (linksActive) {
                    Class<SummaryPage> linkPage = SummaryPage.class;
                    PageParameters pp = WicketUtils.newRepositoryParameter(entry.name);
                    firstColumn.add(new Component[]{new LinkPanel("repositoryName", "list", repoName, linkPage, pp)});
                    rowContent.add(new Component[]{new LinkPanel("repositoryDescription", "list", entry.description, linkPage, pp)});
                } else {
                    firstColumn.add(new Component[]{new Label("repositoryName", repoName)});
                    rowContent.add(new Component[]{new Label("repositoryDescription", entry.description)});
                }
                if (entry.hasCommits) {
                    rowContent.add(new Component[]{new Label("repositorySize", entry.size).setVisible(showSize)});
                } else {
                    rowContent.add(new Component[]{new Label("repositorySize", "<span class='empty'>(" + this.getString("gb.empty") + ")</span>").setEscapeModelStrings(false)});
                }
                if (entry.isSparkleshared()) {
                    rowContent.add(new Component[]{WicketUtils.newImage("sparkleshareIcon", "star_16x16.png", this.getString("gb.isSparkleshared"))});
                } else {
                    rowContent.add(new Component[]{WicketUtils.newClearPixel("sparkleshareIcon").setVisible(false)});
                }
                if (!entry.isMirror && entry.isFrozen) {
                    rowContent.add(new Component[]{WicketUtils.newImage("frozenIcon", "cold_16x16.png", this.getString("gb.isFrozen"))});
                } else {
                    rowContent.add(new Component[]{WicketUtils.newClearPixel("frozenIcon").setVisible(false)});
                }
                if (entry.isFederated) {
                    rowContent.add(new Component[]{WicketUtils.newImage("federatedIcon", "federated_16x16.png", this.getString("gb.isFederated"))});
                } else {
                    rowContent.add(new Component[]{WicketUtils.newClearPixel("federatedIcon").setVisible(false)});
                }
                if (entry.isMirror) {
                    rowContent.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "mirror_16x16.png", this.getString("gb.isMirror"))});
                } else {
                    switch (entry.accessRestriction) {
                        case NONE: {
                            rowContent.add(new Component[]{WicketUtils.newBlankImage("accessRestrictionIcon")});
                            break;
                        }
                        case PUSH: {
                            rowContent.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "lock_go_16x16.png", (String)accessRestrictionTranslations.get((Object)entry.accessRestriction))});
                            break;
                        }
                        case CLONE: {
                            rowContent.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "lock_pull_16x16.png", (String)accessRestrictionTranslations.get((Object)entry.accessRestriction))});
                            break;
                        }
                        case VIEW: {
                            rowContent.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "shield_16x16.png", (String)accessRestrictionTranslations.get((Object)entry.accessRestriction))});
                            break;
                        }
                        default: {
                            rowContent.add(new Component[]{WicketUtils.newBlankImage("accessRestrictionIcon")});
                        }
                    }
                }
                String owner = "";
                if (!ArrayUtils.isEmpty(entry.owners)) {
                    for (String username : entry.owners) {
                        UserModel ownerModel = NestedRepositoryTreePanel.this.app().users().getUserModel(username);
                        if (ownerModel == null) continue;
                        owner = ownerModel.getDisplayName();
                        break;
                    }
                    if (entry.owners.size() > 1) {
                        owner = owner + ", ...";
                    }
                }
                Label ownerLabel = new Label("repositoryOwner", owner);
                WicketUtils.setHtmlTooltip((Component)ownerLabel, ArrayUtils.toString(entry.owners));
                rowContent.add(new Component[]{ownerLabel});
                String lastChange = entry.lastChange.getTime() == 0L ? "--" : NestedRepositoryTreePanel.this.getTimeUtils().timeAgo(entry.lastChange);
                Label lastChangeLabel = new Label("repositoryLastChange", lastChange);
                rowContent.add(new Component[]{lastChangeLabel});
                WicketUtils.setCssClass((Component)lastChangeLabel, NestedRepositoryTreePanel.this.getTimeUtils().timeAgoCss(entry.lastChange));
                if (!StringUtils.isEmpty(entry.lastChangeAuthor)) {
                    WicketUtils.setHtmlTooltip((Component)lastChangeLabel, this.getString("gb.author") + ": " + entry.lastChangeAuthor);
                }
                String clazz = this.counter % 2 == 0 ? "light" : "dark";
                WicketUtils.addCssClass((Component)rowContent, clazz);
                ++this.counter;
            }
        }});
        this.add(new Component[]{new ListView<TreeNodeModel>("subFolders", node.getSubFolders()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<TreeNodeModel> item) {
                item.add(new Component[]{new NestedRepositoryTreePanel("rowContent", (IModel<TreeNodeModel>)item.getModel(), accessRestrictionTranslations, linksActive)});
            }

            public boolean isVisible() {
                return super.isVisible() && !node.getSubFolders().isEmpty();
            }
        }});
    }

    private void addChildOfNodeIdCssClassesToRow(Component row, TreeNodeModel parentNode) {
        row.add(new IBehavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)("child-of-" + parentNode.hashCode()))), " ")});
        if (parentNode.getParent() != null) {
            this.addChildOfNodeIdCssClassesToRow(row, parentNode.getParent());
        }
    }
}

