/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import java.util.List;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.ClientInfo;
import org.apache.wicket.util.value.IValueMap;

public abstract class ObjectContainer
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_CONTENTTYPE = "type";
    private static final String ATTRIBUTE_CLASSID = "classid";
    private static final String ATTRIBUTE_CODEBASE = "codebase";
    private ClientProperties clientProperties = null;

    public ObjectContainer(String id) {
        super(id);
    }

    public abstract void setValue(String var1, String var2);

    public abstract String getValue(String var1);

    protected abstract String getContentType();

    protected abstract String getClsid();

    protected abstract String getCodebase();

    protected abstract List<String> getAttributeNames();

    protected abstract List<String> getParameterNames();

    protected String resolveResource(String src) {
        if (src.startsWith("/") || src.startsWith("http://") || src.startsWith("https://")) {
            return src;
        }
        MarkupContainer parent = this.getParent();
        if (parent instanceof Fragment) {
            parent = parent.getParent();
        }
        if (parent != null) {
            ResourceReference resRef = new ResourceReference(parent.getClass(), src, false);
            return this.urlFor(resRef).toString();
        }
        return src;
    }

    public void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        IValueMap attributeMap = tag.getAttributes();
        String contentType = this.getContentType();
        if (contentType != null && !"".equals(contentType)) {
            attributeMap.put((Object)ATTRIBUTE_CONTENTTYPE, (Object)contentType);
        }
        if (this.getClientProperties().isBrowserInternetExplorer()) {
            String clsid = this.getClsid();
            String codeBase = this.getCodebase();
            if (clsid != null && !"".equals(clsid)) {
                attributeMap.put((Object)ATTRIBUTE_CLASSID, (Object)clsid);
            }
            if (codeBase != null && !"".equals(codeBase)) {
                attributeMap.put((Object)ATTRIBUTE_CODEBASE, (Object)codeBase);
            }
        }
        for (String name : this.getAttributeNames()) {
            String value = this.getValue(name);
            if (value == null) continue;
            attributeMap.put((Object)name, (Object)value);
        }
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        Response response = this.getResponse();
        response.write((CharSequence)"\n");
        for (String name : this.getParameterNames()) {
            String value = this.getValue(name);
            if (value == null) continue;
            response.write((CharSequence)"<param name=\"");
            response.write((CharSequence)name);
            response.write((CharSequence)"\" value=\"");
            response.write((CharSequence)value);
            response.write((CharSequence)"\"/>\n");
        }
        super.onComponentTagBody(markupStream, openTag);
    }

    protected ClientProperties getClientProperties() {
        if (this.clientProperties == null) {
            ClientInfo clientInfo = WebSession.get().getClientInfo();
            if (clientInfo == null || !(clientInfo instanceof WebClientInfo)) {
                clientInfo = new WebClientInfo((WebRequestCycle)this.getRequestCycle());
                WebSession.get().setClientInfo(clientInfo);
            }
            this.clientProperties = ((WebClientInfo)clientInfo).getProperties();
        }
        return this.clientProperties;
    }
}

