/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.LinkPanel;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class PathBreadcrumbsPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String ROOT = "--ROOT--";

    public PathBreadcrumbsPanel(String id, final String repositoryName, String pathName, final String objectId) {
        super(id);
        ArrayList<BreadCrumb> crumbs = new ArrayList<BreadCrumb>();
        crumbs.add(new BreadCrumb("[" + repositoryName + "]", ROOT, false));
        if (pathName != null && pathName.length() > 0) {
            String[] paths = pathName.split("/");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                sb.append(path);
                crumbs.add(new BreadCrumb(path, sb.toString(), i == paths.length - 1));
                sb.append('/');
            }
        }
        ListDataProvider crumbsDp = new ListDataProvider(crumbs);
        DataView<BreadCrumb> pathsView = new DataView<BreadCrumb>("path", (IDataProvider)crumbsDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<BreadCrumb> item) {
                BreadCrumb entry = (BreadCrumb)item.getModelObject();
                String path = entry.path;
                if (path.equals(PathBreadcrumbsPanel.ROOT)) {
                    path = null;
                }
                if (entry.isLeaf) {
                    item.add(new Component[]{new Label("pathLink", entry.name)});
                    item.add(new Component[]{new Label("pathSeparator", "").setVisible(false)});
                } else {
                    item.add(new Component[]{new LinkPanel("pathLink", null, entry.name, TreePage.class, WicketUtils.newPathParameter(repositoryName, objectId, path))});
                    item.add(new Component[]{new Label("pathSeparator", "/")});
                }
            }
        };
        this.add(new Component[]{pathsView});
    }

    private static class BreadCrumb
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String name;
        final String path;
        final boolean isLeaf;

        BreadCrumb(String name, String path, boolean isLeaf) {
            this.name = name;
            this.path = path;
            this.isLeaf = isLeaf;
        }
    }
}

