/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.servlet.SyndicationServlet;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.EditRepositoryPage;
import com.gitblit.wicket.pages.LogPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.Localizer;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.Fragment;

public class ProjectRepositoryPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;

    public ProjectRepositoryPanel(String wicketId, Localizer localizer, Component parent, boolean isAdmin, RepositoryModel entry, Map<Constants.AccessRestrictionType, String> accessRestrictions) {
        super(wicketId);
        Fragment repositoryLinks;
        boolean showSwatch = this.app().settings().getBoolean("web.repositoryListSwatches", true);
        boolean showSize = this.app().settings().getBoolean("web.showRepositorySizes", true);
        PageParameters pp = WicketUtils.newRepositoryParameter(entry.name);
        this.add(new Component[]{new LinkPanel("repositoryName", "list", StringUtils.getRelativePath(entry.projectPath, StringUtils.stripDotGit(entry.name)), SummaryPage.class, pp)});
        this.add(new Component[]{new Label("repositoryDescription", entry.description).setVisible(!StringUtils.isEmpty(entry.description))});
        Fragment iconFragment = entry.isMirror ? new Fragment("repoIcon", "mirrorIconFragment", (MarkupContainer)this) : (entry.isFork() ? new Fragment("repoIcon", "forkIconFragment", (MarkupContainer)this) : (entry.isBare ? new Fragment("repoIcon", "repoIconFragment", (MarkupContainer)this) : new Fragment("repoIcon", "cloneIconFragment", (MarkupContainer)this)));
        if (showSwatch) {
            WicketUtils.setCssStyle((Component)iconFragment, "color:" + StringUtils.getColor(entry.toString()));
        }
        this.add(new Component[]{iconFragment});
        if (StringUtils.isEmpty(entry.originRepository)) {
            this.add(new Component[]{new Label("originRepository").setVisible(false)});
        } else {
            Fragment forkFrag = new Fragment("originRepository", "originFragment", (MarkupContainer)this);
            forkFrag.add(new Component[]{new LinkPanel("originRepository", null, StringUtils.stripDotGit(entry.originRepository), SummaryPage.class, WicketUtils.newRepositoryParameter(entry.originRepository))});
            this.add(new Component[]{forkFrag});
        }
        if (entry.isSparkleshared()) {
            this.add(new Component[]{WicketUtils.newImage("sparkleshareIcon", "star_16x16.png", localizer.getString("gb.isSparkleshared", parent))});
        } else {
            this.add(new Component[]{WicketUtils.newClearPixel("sparkleshareIcon").setVisible(false)});
        }
        if (!entry.isMirror && entry.isFrozen) {
            this.add(new Component[]{WicketUtils.newImage("frozenIcon", "cold_16x16.png", localizer.getString("gb.isFrozen", parent))});
        } else {
            this.add(new Component[]{WicketUtils.newClearPixel("frozenIcon").setVisible(false)});
        }
        if (entry.isFederated) {
            this.add(new Component[]{WicketUtils.newImage("federatedIcon", "federated_16x16.png", localizer.getString("gb.isFederated", parent))});
        } else {
            this.add(new Component[]{WicketUtils.newClearPixel("federatedIcon").setVisible(false)});
        }
        if (ArrayUtils.isEmpty(entry.owners)) {
            this.add(new Component[]{new Label("repositoryOwner").setVisible(false)});
        } else {
            String owner = "";
            for (String username : entry.owners) {
                UserModel ownerModel = this.app().users().getUserModel(username);
                if (ownerModel == null) continue;
                owner = ownerModel.getDisplayName();
            }
            if (entry.owners.size() > 1) {
                owner = owner + ", ...";
            }
            Label ownerLabel = new Label("repositoryOwner", owner + " (" + localizer.getString("gb.owner", parent) + ")");
            WicketUtils.setHtmlTooltip((Component)ownerLabel, ArrayUtils.toString(entry.owners));
            this.add(new Component[]{ownerLabel});
        }
        UserModel user = GitBlitWebSession.get().getUser();
        if (user == null) {
            user = UserModel.ANONYMOUS;
        }
        if (user.canAdmin(entry)) {
            repositoryLinks = new Fragment("repositoryLinks", "repositoryOwnerLinks", (MarkupContainer)this);
            repositoryLinks.add(new Component[]{new BookmarkablePageLink("editRepository", EditRepositoryPage.class, WicketUtils.newRepositoryParameter(entry.name))});
        } else {
            repositoryLinks = new Fragment("repositoryLinks", "repositoryUserLinks", (MarkupContainer)this);
        }
        repositoryLinks.add(new Component[]{new BookmarkablePageLink("tree", TreePage.class, WicketUtils.newRepositoryParameter(entry.name)).setEnabled(entry.hasCommits)});
        repositoryLinks.add(new Component[]{new BookmarkablePageLink("log", LogPage.class, WicketUtils.newRepositoryParameter(entry.name)).setEnabled(entry.hasCommits)});
        this.add(new Component[]{repositoryLinks});
        String lastChange = entry.lastChange.getTime() == 0L ? "--" : this.getTimeUtils().timeAgo(entry.lastChange);
        Label lastChangeLabel = new Label("repositoryLastChange", lastChange);
        this.add(new Component[]{lastChangeLabel});
        WicketUtils.setCssClass((Component)lastChangeLabel, this.getTimeUtils().timeAgoCss(entry.lastChange));
        if (entry.hasCommits) {
            this.add(new Component[]{new Label("repositorySize", entry.size).setVisible(showSize)});
        } else {
            this.add(new Component[]{new Label("repositorySize", localizer.getString("gb.empty", parent)).setEscapeModelStrings(false)});
        }
        this.add(new Component[]{new ExternalLink("syndication", SyndicationServlet.asLink(this.getRequest().getRelativePathPrefixToContextRoot(), entry.name, null, 0))});
    }
}

