/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.models.RefLogEntry;
import com.gitblit.models.RepositoryCommit;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.RefLogUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.TimeUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.ComparePage;
import com.gitblit.wicket.pages.ReflogPage;
import com.gitblit.wicket.pages.TagPage;
import com.gitblit.wicket.pages.TicketsPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.panels.AvatarImage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ReceiveCommand;

public class ReflogPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private final boolean hasChanges;
    private boolean hasMore;

    public ReflogPanel(String wicketId, RepositoryModel model, Repository r, int limit, int pageOffset) {
        super(wicketId);
        boolean pageResults = limit <= 0;
        int changesPerPage = this.app().settings().getInteger("web.reflogChangesPerPage", 10);
        if (changesPerPage <= 1) {
            changesPerPage = 10;
        }
        List<RefLogEntry> changes = pageResults ? RefLogUtils.getLogByRef(model.name, r, pageOffset * changesPerPage, changesPerPage) : RefLogUtils.getLogByRef(model.name, r, limit);
        this.hasMore = changes.size() >= changesPerPage;
        this.hasChanges = changes.size() > 0;
        this.setup(changes);
        if (limit <= 0) {
            this.add(new Component[]{new Label("moreChanges").setVisible(false)});
        } else if (pageResults) {
            this.add(new Component[]{new Label("moreChanges").setVisible(false)});
        } else if (changes.size() == limit) {
            this.add(new Component[]{new LinkPanel("moreChanges", "link", (IModel<String>)new StringResourceModel("gb.moreChanges", (Component)this, null), ReflogPage.class, WicketUtils.newRepositoryParameter(model.name))});
        } else {
            this.add(new Component[]{new Label("moreChanges").setVisible(false)});
        }
    }

    public ReflogPanel(String wicketId, List<RefLogEntry> changes) {
        super(wicketId);
        this.hasChanges = changes.size() > 0;
        this.setup(changes);
        this.add(new Component[]{new Label("moreChanges").setVisible(false)});
    }

    protected void setup(List<RefLogEntry> changes) {
        ListDataProvider dp = new ListDataProvider(changes);
        DataView<RefLogEntry> changeView = new DataView<RefLogEntry>("change", (IDataProvider)dp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<RefLogEntry> changeItem) {
                String what;
                String fuzzydate;
                String fullRefName;
                final RefLogEntry change = (RefLogEntry)changeItem.getModelObject();
                String dateFormat = ReflogPanel.this.app().settings().getString("web.datetimestampLongFormat", "EEEE, MMMM d, yyyy HH:mm Z");
                TimeZone timezone = ReflogPanel.this.getTimeZone();
                SimpleDateFormat df = new SimpleDateFormat(dateFormat);
                df.setTimeZone(timezone);
                Calendar cal = Calendar.getInstance(timezone);
                String shortRefName = fullRefName = change.getChangedRefs().get(0);
                String ticketId = null;
                boolean isTag = false;
                boolean isTicket = false;
                if (shortRefName.startsWith("refs/heads/ticket/")) {
                    ticketId = fullRefName.substring("refs/heads/ticket/".length());
                    shortRefName = MessageFormat.format(this.getString("gb.ticketN"), ticketId);
                    isTicket = true;
                } else if (shortRefName.startsWith("refs/heads/")) {
                    shortRefName = shortRefName.substring("refs/heads/".length());
                } else if (shortRefName.startsWith("refs/tags/")) {
                    shortRefName = shortRefName.substring("refs/tags/".length());
                    isTag = true;
                }
                TimeUtils tu = ReflogPanel.this.getTimeUtils();
                Date changeDate = change.date;
                if (TimeUtils.isToday(changeDate, timezone)) {
                    fuzzydate = tu.today();
                } else if (TimeUtils.isYesterday(changeDate, timezone)) {
                    fuzzydate = tu.yesterday();
                } else {
                    cal.setTime(changeDate);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    Date date = cal.getTime();
                    fuzzydate = ReflogPanel.this.getTimeUtils().timeAgo(date);
                }
                changeItem.add(new Component[]{new Label("whenChanged", fuzzydate + ", " + df.format(changeDate))});
                Label changeIcon = new Label("changeIcon");
                if (ReceiveCommand.Type.DELETE.equals((Object)change.getChangeType(fullRefName))) {
                    WicketUtils.setCssClass((Component)changeIcon, "iconic-trash-stroke");
                } else if (isTag) {
                    WicketUtils.setCssClass((Component)changeIcon, "iconic-tag");
                } else if (isTicket) {
                    WicketUtils.setCssClass((Component)changeIcon, "fa fa-ticket");
                } else {
                    WicketUtils.setCssClass((Component)changeIcon, "iconic-upload");
                }
                changeItem.add(new Component[]{changeIcon});
                if (change.user.username.equals(change.user.emailAddress) && change.user.emailAddress.indexOf(64) > -1) {
                    changeItem.add(new Component[]{new Label("whoChanged", change.user.getDisplayName())});
                } else if (change.user.username.equals(UserModel.ANONYMOUS.username)) {
                    changeItem.add(new Component[]{new Label("whoChanged", this.getString("gb.anonymousUser"))});
                } else {
                    changeItem.add(new Component[]{new LinkPanel("whoChanged", null, change.user.getDisplayName(), UserPage.class, WicketUtils.newUsernameParameter(change.user.username))});
                }
                boolean isDelete = false;
                boolean isRewind = false;
                String by = null;
                switch (change.getChangeType(fullRefName)) {
                    case CREATE: {
                        if (isTag) {
                            what = this.getString("gb.pushedNewTag");
                            break;
                        }
                        what = this.getString("gb.pushedNewBranch");
                        break;
                    }
                    case DELETE: {
                        isDelete = true;
                        if (isTag) {
                            what = this.getString("gb.deletedTag");
                            break;
                        }
                        what = this.getString("gb.deletedBranch");
                        break;
                    }
                    case UPDATE_NONFASTFORWARD: {
                        isRewind = true;
                    }
                    default: {
                        what = MessageFormat.format(change.getCommitCount() > 1 ? this.getString("gb.pushedNCommitsTo") : this.getString("gb.pushedOneCommitTo"), change.getCommitCount());
                        by = change.getAuthorCount() == 1 ? MessageFormat.format(this.getString("gb.byOneAuthor"), change.getAuthorIdent().getName()) : MessageFormat.format(this.getString("gb.byNAuthors"), change.getAuthorCount());
                    }
                }
                changeItem.add(new Component[]{new Label("whatChanged", what)});
                changeItem.add(new Component[]{new Label("byAuthors", by).setVisible(!StringUtils.isEmpty(by))});
                changeItem.add(new Component[]{new Label("refRewind", this.getString("gb.rewind")).setVisible(isRewind)});
                if (isDelete) {
                    changeItem.add(new Component[]{new Label("refChanged", shortRefName)});
                } else if (isTag) {
                    changeItem.add(new Component[]{new LinkPanel("refChanged", null, shortRefName, TagPage.class, WicketUtils.newObjectParameter(change.repository, fullRefName))});
                } else if (isTicket) {
                    changeItem.add(new Component[]{new LinkPanel("refChanged", null, shortRefName, TicketsPage.class, WicketUtils.newObjectParameter(change.repository, ticketId))});
                } else {
                    changeItem.add(new Component[]{new LinkPanel("refChanged", null, shortRefName, TreePage.class, WicketUtils.newObjectParameter(change.repository, fullRefName))});
                }
                int maxCommitCount = 5;
                List<RepositoryCommit> commits = change.getCommits();
                if (commits.size() > maxCommitCount) {
                    commits = new ArrayList<RepositoryCommit>(commits.subList(0, maxCommitCount));
                }
                String compareLinkText = null;
                if (change.getCommitCount() <= maxCommitCount && change.getCommitCount() > 1) {
                    compareLinkText = MessageFormat.format(this.getString("gb.viewComparison"), commits.size());
                } else if (change.getCommitCount() > maxCommitCount) {
                    int diff = change.getCommitCount() - maxCommitCount;
                    compareLinkText = MessageFormat.format(diff > 1 ? this.getString("gb.nMoreCommits") : this.getString("gb.oneMoreCommit"), diff);
                }
                if (StringUtils.isEmpty(compareLinkText)) {
                    changeItem.add(new Component[]{new Label("compareLink").setVisible(false)});
                } else {
                    String endRangeId = change.getNewId(fullRefName);
                    String startRangeId = change.getOldId(fullRefName);
                    changeItem.add(new Component[]{new LinkPanel("compareLink", null, compareLinkText, ComparePage.class, WicketUtils.newRangeParameter(change.repository, startRangeId, endRangeId))});
                }
                ListDataProvider cdp = new ListDataProvider(commits);
                DataView<RepositoryCommit> commitsView = new DataView<RepositoryCommit>("commit", (IDataProvider)cdp){
                    private static final long serialVersionUID = 1L;

                    public void populateItem(Item<RepositoryCommit> commitItem) {
                        String shortMessage;
                        RepositoryCommit commit = (RepositoryCommit)commitItem.getModelObject();
                        commitItem.add(new Component[]{new AvatarImage("commitAuthor", commit.getAuthorIdent(), null, 16, false)});
                        if (commit.getParentCount() > 1) {
                            commitItem.add(new Component[]{WicketUtils.newImage("commitIcon", "commit_merge_16x16.png")});
                        } else {
                            commitItem.add(new Component[]{WicketUtils.newBlankImage("commitIcon")});
                        }
                        String trimmedMessage = shortMessage = commit.getShortMessage();
                        trimmedMessage = commit.getRefs() != null && commit.getRefs().size() > 0 ? StringUtils.trimString(shortMessage, 60) : StringUtils.trimString(shortMessage, 78);
                        LinkPanel shortlog = new LinkPanel("commitShortMessage", "list", trimmedMessage, CommitPage.class, WicketUtils.newObjectParameter(change.repository, commit.getName()));
                        if (!shortMessage.equals(trimmedMessage)) {
                            WicketUtils.setHtmlTooltip((Component)shortlog, shortMessage);
                        }
                        commitItem.add(new Component[]{shortlog});
                        int hashLen = ReflogPanel.this.app().settings().getInteger("web.shortCommitIdLength", 6);
                        LinkPanel commitHash = new LinkPanel("hashLink", null, commit.getName().substring(0, hashLen), CommitPage.class, WicketUtils.newObjectParameter(change.repository, commit.getName()));
                        WicketUtils.setCssClass((Component)commitHash, "shortsha1");
                        WicketUtils.setHtmlTooltip((Component)commitHash, commit.getName());
                        commitItem.add(new Component[]{commitHash});
                    }
                };
                changeItem.add(new Component[]{commitsView});
            }
        };
        this.add(new Component[]{changeView});
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public boolean hideIfEmpty() {
        this.setVisible(this.hasChanges);
        return this.hasChanges;
    }
}

