/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.LogPage;
import com.gitblit.wicket.pages.TagPage;
import com.gitblit.wicket.pages.TicketsPage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

public class RefsPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;

    public RefsPanel(String id, String repositoryName, RevCommit c, Map<ObjectId, List<RefModel>> refs) {
        this(id, repositoryName, refs.get(c.getId()));
    }

    public RefsPanel(String id, final String repositoryName, List<RefModel> refs) {
        super(id);
        if (refs == null) {
            refs = new ArrayList<RefModel>();
        }
        Collections.sort(refs, new Comparator<RefModel>(){

            @Override
            public int compare(RefModel o1, RefModel o2) {
                boolean remote1 = o1.displayName.startsWith("refs/remotes/");
                boolean remote2 = o2.displayName.startsWith("refs/remotes/");
                if (remote1 && remote2) {
                    return o1.displayName.compareTo(o2.displayName);
                }
                if (remote1) {
                    return 1;
                }
                if (remote2) {
                    return -1;
                }
                return o1.displayName.compareTo(o2.displayName);
            }
        });
        int remoteCount = 0;
        for (RefModel ref : refs) {
            if (!ref.displayName.startsWith("refs/remotes/")) continue;
            ++remoteCount;
        }
        final boolean shouldBreak = remoteCount < refs.size();
        RepositoryModel repository = this.app().repositories().getRepositoryModel(repositoryName);
        boolean hasTickets = this.app().tickets().hasTickets(repository);
        ListDataProvider refsDp = new ListDataProvider(refs);
        DataView<RefModel> refsView = new DataView<RefModel>("ref", (IDataProvider)refsDp){
            private static final long serialVersionUID = 1L;
            private boolean alreadyInsertedBreak;
            {
                super(x0, x1);
                this.alreadyInsertedBreak = !shouldBreak;
            }

            public void populateItem(Item<RefModel> item) {
                String[] values;
                RefModel entry = (RefModel)item.getModelObject();
                String name = entry.displayName;
                String objectid = entry.getReferencedObjectId().getName();
                boolean breakLine = false;
                Class linkClass = CommitPage.class;
                String cssClass = "";
                String tooltip = "";
                if (name.startsWith("refs/heads/ticket/")) {
                    objectid = name.substring("refs/heads/ticket/".length());
                    name = name.substring("refs/heads/".length());
                    linkClass = TicketsPage.class;
                    cssClass = "localBranch";
                } else if (name.startsWith("refs/heads/")) {
                    linkClass = LogPage.class;
                    name = name.substring("refs/heads/".length());
                    cssClass = "localBranch";
                } else if (name.equals("HEAD")) {
                    linkClass = LogPage.class;
                    cssClass = "headRef";
                } else if (name.startsWith("refs/changes/")) {
                    name = name.substring("refs/changes/".length());
                    name = name.substring(name.indexOf(47) + 1).replace('/', '-');
                    values = name.split("-");
                    tooltip = MessageFormat.format(this.getString("gb.reviewPatchset"), values[0], values[1]);
                    cssClass = "otherRef";
                } else if (name.startsWith("refs/tickets/")) {
                    name = name.substring("refs/tickets/".length());
                    name = name.substring(name.indexOf(47) + 1).replace('/', '-');
                    values = name.split("-");
                    tooltip = MessageFormat.format(this.getString("gb.ticketPatchset"), values[0], values[1]);
                    linkClass = LogPage.class;
                    cssClass = "otherRef";
                } else if (name.startsWith("refs/pull/")) {
                    String num = name.substring("refs/pull/".length());
                    if (num.endsWith("/head")) {
                        num = num.substring(0, num.length() - "/head".length());
                    }
                    name = "pr #" + num;
                    tooltip = "pull request #" + num;
                    cssClass = "pullRef";
                } else if (name.startsWith("refs/remotes/")) {
                    linkClass = LogPage.class;
                    name = name.substring("refs/remotes/".length());
                    cssClass = "remoteBranch";
                    if (!this.alreadyInsertedBreak) {
                        breakLine = true;
                        this.alreadyInsertedBreak = true;
                    }
                } else if (name.startsWith("refs/tags/")) {
                    if (entry.isAnnotatedTag()) {
                        linkClass = TagPage.class;
                        objectid = entry.getObjectId().getName();
                    } else {
                        linkClass = CommitPage.class;
                        objectid = entry.getReferencedObjectId().getName();
                    }
                    name = name.substring("refs/tags/".length());
                    cssClass = "tagRef";
                } else if (name.startsWith("refs/notes/")) {
                    linkClass = CommitPage.class;
                    cssClass = "otherRef";
                } else if (name.startsWith("refs/meta/")) {
                    linkClass = LogPage.class;
                    cssClass = "otherRef";
                    name = name.substring("refs/meta/".length());
                }
                LinkPanel c = new LinkPanel("refName", null, name, linkClass, WicketUtils.newObjectParameter(repositoryName, objectid));
                WicketUtils.setCssClass((Component)c, cssClass);
                if (StringUtils.isEmpty(tooltip)) {
                    WicketUtils.setHtmlTooltip((Component)c, name);
                } else {
                    WicketUtils.setHtmlTooltip((Component)c, tooltip);
                }
                item.add(new Component[]{c});
                Label lb = new Label("lineBreak", "<br/>");
                lb.setVisible(breakLine);
                lb.setRenderBodyOnly(true);
                item.add(new Component[]{lb.setEscapeModelStrings(false)});
                item.setRenderBodyOnly(true);
            }
        };
        this.add(new Component[]{refsView});
    }
}

