/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.UserModel;
import com.gitblit.utils.DeepCopier;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.panels.AvatarImage;
import com.gitblit.wicket.panels.BasePanel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.markup.repeater.util.ModelIteratorAdapter;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.eclipse.jgit.lib.PersonIdent;

public class RegistrantPermissionsPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private Show activeState = Show.mutable;

    public RegistrantPermissionsPanel(String wicketId, Constants.RegistrantType registrantType, List<String> allRegistrants, final List<RegistrantAccessPermission> permissions, final Map<Constants.AccessPermission, String> translations) {
        super(wicketId);
        this.setOutputMarkupId(true);
        Form permissionToggleForm = new Form("permissionToggleForm");
        permissionToggleForm.add(new Component[]{new ShowStateButton("showSpecified", Show.specified)});
        permissionToggleForm.add(new Component[]{new ShowStateButton("showMutable", Show.mutable)});
        permissionToggleForm.add(new Component[]{new ShowStateButton("showEffective", Show.effective)});
        this.add(new Component[]{permissionToggleForm});
        RefreshingView<RegistrantAccessPermission> dataView = new RefreshingView<RegistrantAccessPermission>("permissionRow"){
            private static final long serialVersionUID = 1L;

            protected Iterator<IModel<RegistrantAccessPermission>> getItemModels() {
                return new ModelIteratorAdapter<RegistrantAccessPermission>(permissions.iterator()){

                    protected IModel<RegistrantAccessPermission> model(RegistrantAccessPermission permission) {
                        return new CompoundPropertyModel((Object)permission);
                    }
                };
            }

            protected Item<RegistrantAccessPermission> newItem(String id, int index, IModel<RegistrantAccessPermission> model) {
                return new OddEvenItem(id, index, model);
            }

            public void populateItem(Item<RegistrantAccessPermission> item) {
                RegistrantAccessPermission entry = (RegistrantAccessPermission)item.getModelObject();
                if (Constants.RegistrantType.REPOSITORY.equals((Object)entry.registrantType)) {
                    String repoName = StringUtils.stripDotGit(entry.registrant);
                    if (!entry.isMissing() && StringUtils.findInvalidCharacter(repoName) == null) {
                        Fragment repositoryFragment = new Fragment("registrant", "repositoryRegistrant", (MarkupContainer)RegistrantPermissionsPanel.this);
                        Component swatch = new Label("repositorySwatch", "&nbsp;").setEscapeModelStrings(false);
                        WicketUtils.setCssBackground(swatch, entry.toString());
                        repositoryFragment.add(new Component[]{swatch});
                        Label registrant = new Label("repositoryName", repoName);
                        repositoryFragment.add(new Component[]{registrant});
                        item.add(new Component[]{repositoryFragment});
                    } else {
                        Label label = new Label("registrant", entry.registrant);
                        WicketUtils.setCssStyle((Component)label, "font-weight: bold;");
                        item.add(new Component[]{label});
                    }
                } else if (Constants.RegistrantType.USER.equals((Object)entry.registrantType)) {
                    PersonIdent ident = new PersonIdent(entry.registrant, "");
                    UserModel user = RegistrantPermissionsPanel.this.app().users().getUserModel(entry.registrant);
                    if (user != null) {
                        ident = new PersonIdent(user.getDisplayName(), user.emailAddress == null ? user.getDisplayName() : user.emailAddress);
                    }
                    Fragment userFragment = new Fragment("registrant", "userRegistrant", (MarkupContainer)RegistrantPermissionsPanel.this);
                    userFragment.add(new Component[]{new AvatarImage("userAvatar", ident, 20)});
                    userFragment.add(new Component[]{new Label("userName", entry.registrant)});
                    item.add(new Component[]{userFragment});
                } else {
                    Fragment teamFragment = new Fragment("registrant", "teamRegistrant", (MarkupContainer)RegistrantPermissionsPanel.this);
                    teamFragment.add(new Component[]{new Label("teamName", entry.registrant)});
                    item.add(new Component[]{teamFragment});
                }
                switch (entry.permissionType) {
                    case ADMINISTRATOR: {
                        Label administrator = new Label("pType", entry.source == null ? this.getString("gb.administrator") : entry.source);
                        WicketUtils.setHtmlTooltip((Component)administrator, this.getString("gb.administratorPermission"));
                        WicketUtils.setCssClass((Component)administrator, "label label-inverse");
                        item.add(new Component[]{administrator});
                        break;
                    }
                    case OWNER: {
                        Label owner = new Label("pType", this.getString("gb.owner"));
                        WicketUtils.setHtmlTooltip((Component)owner, this.getString("gb.ownerPermission"));
                        WicketUtils.setCssClass((Component)owner, "label label-info");
                        item.add(new Component[]{owner});
                        break;
                    }
                    case TEAM: {
                        Label team = new Label("pType", entry.source == null ? this.getString("gb.team") : entry.source);
                        WicketUtils.setHtmlTooltip((Component)team, MessageFormat.format(this.getString("gb.teamPermission"), entry.source));
                        WicketUtils.setCssClass((Component)team, "label label-success");
                        item.add(new Component[]{team});
                        break;
                    }
                    case REGEX: {
                        Label regex2 = new Label("pType", "regex");
                        if (!StringUtils.isEmpty(entry.source)) {
                            WicketUtils.setHtmlTooltip((Component)regex2, MessageFormat.format(this.getString("gb.regexPermission"), entry.source));
                        }
                        WicketUtils.setCssClass((Component)regex2, "label");
                        item.add(new Component[]{regex2});
                        break;
                    }
                    default: {
                        if (entry.isMissing()) {
                            Label missing = new Label("pType", this.getString("gb.missing"));
                            WicketUtils.setCssClass((Component)missing, "label label-important");
                            WicketUtils.setHtmlTooltip((Component)missing, this.getString("gb.missingPermission"));
                            item.add(new Component[]{missing});
                            break;
                        }
                        item.add(new Component[]{new Label("pType", "").setVisible(false)});
                    }
                }
                item.setVisible(RegistrantPermissionsPanel.this.activeState.show(entry));
                final DropDownChoice permissionChoice = new DropDownChoice("permission", Arrays.asList(Constants.AccessPermission.values()), (IChoiceRenderer)new AccessPermissionRenderer(translations));
                permissionChoice.setEnabled(entry.mutable);
                permissionChoice.setOutputMarkupId(true);
                if (entry.mutable) {
                    permissionChoice.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                        private static final long serialVersionUID = 1L;

                        protected void onUpdate(AjaxRequestTarget target) {
                            target.addComponent((Component)permissionChoice);
                        }
                    }});
                }
                item.add(new Component[]{permissionChoice});
            }
        };
        this.add(new Component[]{dataView});
        this.setOutputMarkupId(true);
        final ArrayList<String> registrants = new ArrayList<String>(allRegistrants);
        for (RegistrantAccessPermission rp : permissions) {
            if (rp.mutable) {
                registrants.remove(rp.registrant);
                continue;
            }
            if (rp.isAdmin()) {
                registrants.remove(rp.registrant);
                continue;
            }
            if (!rp.isOwner()) continue;
            registrants.remove(rp.registrant);
        }
        CompoundPropertyModel addPermissionModel = new CompoundPropertyModel((Object)new RegistrantAccessPermission(registrantType));
        Form addPermissionForm = new Form("addPermissionForm", (IModel)addPermissionModel);
        addPermissionForm.add(new Component[]{new DropDownChoice("registrant", registrants)});
        addPermissionForm.add(new Component[]{new DropDownChoice("permission", Arrays.asList(Constants.AccessPermission.NEWPERMISSIONS), (IChoiceRenderer)new AccessPermissionRenderer(translations))});
        AjaxButton button = new AjaxButton("addPermissionButton", addPermissionForm){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                RegistrantAccessPermission rp = (RegistrantAccessPermission)form.getModel().getObject();
                if (rp.permission == null) {
                    return;
                }
                if (rp.registrant == null) {
                    return;
                }
                RegistrantAccessPermission copy = DeepCopier.copy(rp);
                if (StringUtils.findInvalidCharacter(copy.registrant) != null) {
                    copy.permissionType = Constants.PermissionType.REGEX;
                    copy.source = copy.registrant;
                }
                permissions.add(copy);
                Collections.sort(permissions);
                registrants.remove(rp.registrant);
                target.addComponent((Component)RegistrantPermissionsPanel.this);
            }
        };
        addPermissionForm.add(new Component[]{button});
        this.add(new Component[]{addPermissionForm.setVisible(registrants.size() > 0)});
    }

    protected boolean getStatelessHint() {
        return false;
    }

    private class ShowStateButton
    extends AjaxButton {
        private static final long serialVersionUID = 1L;
        Show buttonState;

        public ShowStateButton(String wicketId, Show state) {
            super(wicketId);
            this.buttonState = state;
            this.setOutputMarkupId(true);
        }

        protected void onBeforeRender() {
            String cssClass = "btn";
            if (this.buttonState.equals((Object)RegistrantPermissionsPanel.this.activeState)) {
                cssClass = "btn btn-info active";
            }
            WicketUtils.setCssClass((Component)this, cssClass);
            super.onBeforeRender();
        }

        protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
            RegistrantPermissionsPanel.this.activeState = this.buttonState;
            target.addComponent((Component)RegistrantPermissionsPanel.this);
        }
    }

    private class AccessPermissionRenderer
    implements IChoiceRenderer<Constants.AccessPermission> {
        private static final long serialVersionUID = 1L;
        private final Map<Constants.AccessPermission, String> map;

        public AccessPermissionRenderer(Map<Constants.AccessPermission, String> map) {
            this.map = map;
        }

        public String getDisplayValue(Constants.AccessPermission type) {
            return this.map.get((Object)type);
        }

        public String getIdValue(Constants.AccessPermission type, int index) {
            return Integer.toString(index);
        }
    }

    public static enum Show {
        specified,
        mutable,
        effective;


        public boolean show(RegistrantAccessPermission ap) {
            switch (this) {
                case specified: {
                    return ap.mutable || ap.isOwner();
                }
                case mutable: {
                    return ap.mutable;
                }
                case effective: {
                    return true;
                }
            }
            return true;
        }
    }
}

