/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TreeNodeModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.ModelUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.ProjectPage;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.NestedRepositoryTreePanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.OrderByBorder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class RepositoriesPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;

    public RepositoriesPanel(String wicketId, boolean showAdmin, boolean showManagement, List<RepositoryModel> models, boolean enableLinks, final Map<Constants.AccessRestrictionType, String> accessRestrictionTranslations) {
        super(wicketId);
        Fragment allCollapsible;
        Fragment fragment;
        Fragment managementLinks;
        final boolean linksActive = enableLinks;
        final boolean showSize = this.app().settings().getBoolean("web.showRepositorySizes", true);
        String collapsibleRespositorySetting = this.app().settings().getString("web.collapsibleRepositoryGroups", null);
        final CollapsibleRepositorySetting collapsibleRepoGroups = CollapsibleRepositorySetting.get(collapsibleRespositorySetting);
        UserModel user = GitBlitWebSession.get().getUser();
        SortableRepositoriesProvider dp = null;
        if (showAdmin) {
            managementLinks = new Fragment("managementPanel", "adminLinks", (MarkupContainer)this);
            managementLinks.add(new Component[]{new Link<Void>("clearCache"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    RepositoriesPanel.this.app().repositories().resetRepositoryListCache();
                    this.setResponsePage(RepositoriesPage.class);
                }
            }.setVisible(this.app().settings().getBoolean("git.cacheRepositoryList", true))});
            managementLinks.add(new Component[]{new BookmarkablePageLink("newRepository", this.app().getNewRepositoryPage())});
            this.add(new Component[]{managementLinks});
        } else if (showManagement && user != null && user.canCreate()) {
            managementLinks = new Fragment("managementPanel", "personalLinks", (MarkupContainer)this);
            managementLinks.add(new Component[]{new BookmarkablePageLink("newRepository", this.app().getNewRepositoryPage())});
            this.add(new Component[]{managementLinks});
        } else {
            this.add(new Component[]{new Label("managementPanel").setVisible(false)});
        }
        if (this.app().settings().getString("web.repositoryListType", "flat").equalsIgnoreCase("tree")) {
            TreeNodeModel tree = new TreeNodeModel();
            for (RepositoryModel model : models) {
                String rootPath = StringUtils.getRootPath(model.name);
                if (StringUtils.isEmpty(rootPath)) {
                    tree.add(model);
                    continue;
                }
                tree.add(rootPath, model);
            }
            WebMarkupContainer container2 = new WebMarkupContainer("row");
            this.add(new Component[]{container2});
            container2.add(new Component[]{new NestedRepositoryTreePanel("rowContent", (IModel<TreeNodeModel>)Model.of((Serializable)tree), accessRestrictionTranslations, enableLinks)});
            fragment = new Fragment("headerContent", "groupRepositoryHeader", (MarkupContainer)this);
            allCollapsible = new Fragment("allCollapsible", "tableAllCollapsible", (MarkupContainer)this);
            fragment.add(new Component[]{allCollapsible});
            this.add(new Component[]{fragment});
        } else if (this.app().settings().getString("web.repositoryListType", "flat").equalsIgnoreCase("grouped")) {
            ArrayList<RepositoryModel> rootRepositories = new ArrayList<RepositoryModel>();
            HashMap groups = new HashMap();
            for (RepositoryModel model : models) {
                String rootPath = StringUtils.getRootPath(model.name);
                if (StringUtils.isEmpty(rootPath)) {
                    rootRepositories.add(model);
                    continue;
                }
                if (!groups.containsKey(rootPath)) {
                    groups.put(rootPath, new ArrayList());
                }
                ((List)groups.get(rootPath)).add(model);
            }
            ArrayList roots = new ArrayList(groups.keySet());
            Collections.sort(roots);
            if (rootRepositories.size() > 0) {
                roots.add(0, "");
                groups.put("", rootRepositories);
            }
            ArrayList<GroupRepositoryModel> groupedModels = new ArrayList<GroupRepositoryModel>();
            for (String root : roots) {
                List subModels = (List)groups.get(root);
                ProjectModel project = this.app().projects().getProjectModel(root);
                GroupRepositoryModel group = new GroupRepositoryModel(project == null ? root : project.name, subModels.size());
                if (project != null) {
                    group.title = project.title;
                    group.description = project.description;
                }
                groupedModels.add(group);
                Collections.sort(subModels);
                groupedModels.addAll(subModels);
            }
            dp = new ListDataProvider(groupedModels);
        } else {
            dp = new SortableRepositoriesProvider(models);
        }
        if (dp != null) {
            final boolean showSwatch = this.app().settings().getBoolean("web.repositoryListSwatches", true);
            DataView<RepositoryModel> dataView = new DataView<RepositoryModel>("row", (IDataProvider)dp){
                private static final long serialVersionUID = 1L;
                int counter;
                String currGroupName;

                protected void onBeforeRender() {
                    super.onBeforeRender();
                    this.counter = 0;
                }

                public void populateItem(Item<RepositoryModel> item) {
                    RepositoryModel entry = (RepositoryModel)item.getModelObject();
                    if (entry instanceof GroupRepositoryModel) {
                        Fragment groupCollapsible;
                        GroupRepositoryModel groupRow = (GroupRepositoryModel)entry;
                        this.currGroupName = entry.name;
                        Fragment row = new Fragment("rowContent", "groupRepositoryRow", (MarkupContainer)this);
                        if (collapsibleRepoGroups == CollapsibleRepositorySetting.EXPANDED) {
                            groupCollapsible = new Fragment("groupCollapsible", "tableGroupMinusCollapsible", (MarkupContainer)this);
                            row.add(new Component[]{groupCollapsible});
                        } else if (collapsibleRepoGroups == CollapsibleRepositorySetting.COLLAPSED) {
                            groupCollapsible = new Fragment("groupCollapsible", "tableGroupPlusCollapsible", (MarkupContainer)this);
                            row.add(new Component[]{groupCollapsible});
                        } else {
                            groupCollapsible = new Fragment("groupCollapsible", "emptyFragment", (MarkupContainer)this);
                            row.add(new Component[]{groupCollapsible});
                        }
                        item.add(new Component[]{row});
                        String name = groupRow.name;
                        if (name.startsWith(ModelUtils.getUserRepoPrefix())) {
                            String username = ModelUtils.getUserNameFromRepoPath(name);
                            UserModel user = RepositoriesPanel.this.app().users().getUserModel(username);
                            row.add(new Component[]{new LinkPanel("groupName", null, (user == null ? username : user.getDisplayName()) + " (" + groupRow.count + ")", UserPage.class, WicketUtils.newUsernameParameter(username))});
                            row.add(new Component[]{new Label("groupDescription", this.getString("gb.personalRepositories"))});
                        } else {
                            row.add(new Component[]{new LinkPanel("groupName", null, groupRow.toString(), ProjectPage.class, WicketUtils.newProjectParameter(entry.name))});
                            row.add(new Component[]{new Label("groupDescription", entry.description == null ? "" : entry.description)});
                        }
                        WicketUtils.setCssClass(item, "group collapsible");
                        this.counter = 0;
                        return;
                    }
                    Fragment row = new Fragment("rowContent", "repositoryRow", (MarkupContainer)this);
                    item.add(new Component[]{row});
                    Fragment iconFragment = entry.isMirror ? new Fragment("repoIcon", "mirrorIconFragment", (MarkupContainer)this) : (entry.isFork() ? new Fragment("repoIcon", "forkIconFragment", (MarkupContainer)this) : (entry.isBare ? new Fragment("repoIcon", "repoIconFragment", (MarkupContainer)this) : new Fragment("repoIcon", "cloneIconFragment", (MarkupContainer)this)));
                    if (showSwatch) {
                        WicketUtils.setCssStyle((Component)iconFragment, "color:" + StringUtils.getColor(entry.toString()));
                    }
                    row.add(new Component[]{iconFragment});
                    String repoName = entry.toString();
                    if (!StringUtils.isEmpty(this.currGroupName) && repoName.indexOf(47) > -1) {
                        repoName = repoName.substring(this.currGroupName.length() + 1);
                    }
                    if (linksActive) {
                        Class<SummaryPage> linkPage = SummaryPage.class;
                        PageParameters pp = WicketUtils.newRepositoryParameter(entry.name);
                        row.add(new Component[]{new LinkPanel("repositoryName", "list", repoName, linkPage, pp)});
                        row.add(new Component[]{new LinkPanel("repositoryDescription", "list", entry.description, linkPage, pp)});
                    } else {
                        row.add(new Component[]{new Label("repositoryName", repoName)});
                        row.add(new Component[]{new Label("repositoryDescription", entry.description)});
                    }
                    if (entry.hasCommits) {
                        row.add(new Component[]{new Label("repositorySize", entry.size).setVisible(showSize)});
                    } else {
                        row.add(new Component[]{new Label("repositorySize", "<span class='empty'>(" + this.getString("gb.empty") + ")</span>").setEscapeModelStrings(false)});
                    }
                    if (entry.isSparkleshared()) {
                        row.add(new Component[]{WicketUtils.newImage("sparkleshareIcon", "star_16x16.png", this.getString("gb.isSparkleshared"))});
                    } else {
                        row.add(new Component[]{WicketUtils.newClearPixel("sparkleshareIcon").setVisible(false)});
                    }
                    if (!entry.isMirror && entry.isFrozen) {
                        row.add(new Component[]{WicketUtils.newImage("frozenIcon", "cold_16x16.png", this.getString("gb.isFrozen"))});
                    } else {
                        row.add(new Component[]{WicketUtils.newClearPixel("frozenIcon").setVisible(false)});
                    }
                    if (entry.isFederated) {
                        row.add(new Component[]{WicketUtils.newImage("federatedIcon", "federated_16x16.png", this.getString("gb.isFederated"))});
                    } else {
                        row.add(new Component[]{WicketUtils.newClearPixel("federatedIcon").setVisible(false)});
                    }
                    if (entry.isMirror) {
                        row.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "mirror_16x16.png", this.getString("gb.isMirror"))});
                    } else {
                        switch (entry.accessRestriction) {
                            case NONE: {
                                row.add(new Component[]{WicketUtils.newBlankImage("accessRestrictionIcon")});
                                break;
                            }
                            case PUSH: {
                                row.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "lock_go_16x16.png", (String)accessRestrictionTranslations.get((Object)entry.accessRestriction))});
                                break;
                            }
                            case CLONE: {
                                row.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "lock_pull_16x16.png", (String)accessRestrictionTranslations.get((Object)entry.accessRestriction))});
                                break;
                            }
                            case VIEW: {
                                row.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "shield_16x16.png", (String)accessRestrictionTranslations.get((Object)entry.accessRestriction))});
                                break;
                            }
                            default: {
                                row.add(new Component[]{WicketUtils.newBlankImage("accessRestrictionIcon")});
                            }
                        }
                    }
                    String owner = "";
                    if (!ArrayUtils.isEmpty(entry.owners)) {
                        for (String username : entry.owners) {
                            UserModel ownerModel = RepositoriesPanel.this.app().users().getUserModel(username);
                            if (ownerModel == null) continue;
                            owner = ownerModel.getDisplayName();
                            break;
                        }
                        if (entry.owners.size() > 1) {
                            owner = owner + ", ...";
                        }
                    }
                    Label ownerLabel = new Label("repositoryOwner", owner);
                    WicketUtils.setHtmlTooltip((Component)ownerLabel, ArrayUtils.toString(entry.owners));
                    row.add(new Component[]{ownerLabel});
                    String lastChange = entry.lastChange.getTime() == 0L ? "--" : RepositoriesPanel.this.getTimeUtils().timeAgo(entry.lastChange);
                    Label lastChangeLabel = new Label("repositoryLastChange", lastChange);
                    row.add(new Component[]{lastChangeLabel});
                    WicketUtils.setCssClass((Component)lastChangeLabel, RepositoriesPanel.this.getTimeUtils().timeAgoCss(entry.lastChange));
                    if (!StringUtils.isEmpty(entry.lastChangeAuthor)) {
                        WicketUtils.setHtmlTooltip((Component)lastChangeLabel, this.getString("gb.author") + ": " + entry.lastChangeAuthor);
                    }
                    WicketUtils.setAlternatingBackground(item, this.counter);
                    ++this.counter;
                }
            };
            this.add(new Component[]{dataView});
            if (dp instanceof SortableDataProvider) {
                SortableDataProvider sdp = dp;
                Fragment fragment2 = new Fragment("headerContent", "flatRepositoryHeader", (MarkupContainer)this);
                fragment2.add(new Component[]{this.newSort("orderByRepository", SortBy.repository, sdp, dataView)});
                fragment2.add(new Component[]{this.newSort("orderByDescription", SortBy.description, sdp, dataView)});
                fragment2.add(new Component[]{this.newSort("orderByOwner", SortBy.owner, sdp, dataView)});
                fragment2.add(new Component[]{this.newSort("orderByDate", SortBy.date, sdp, dataView)});
                this.add(new Component[]{fragment2});
            } else {
                fragment = new Fragment("headerContent", "groupRepositoryHeader", (MarkupContainer)this);
                if (collapsibleRepoGroups == CollapsibleRepositorySetting.EXPANDED || collapsibleRepoGroups == CollapsibleRepositorySetting.COLLAPSED) {
                    allCollapsible = new Fragment("allCollapsible", "tableAllCollapsible", (MarkupContainer)this);
                    fragment.add(new Component[]{allCollapsible});
                } else {
                    allCollapsible = new Fragment("allCollapsible", "emptyFragment", (MarkupContainer)this);
                    fragment.add(new Component[]{allCollapsible});
                }
                this.add(new Component[]{fragment});
            }
        }
    }

    protected OrderByBorder newSort(String wicketId, SortBy field, SortableDataProvider<?> dp, DataView<?> dataView) {
        return new OrderByBorder(wicketId, field.name(), (ISortStateLocator)dp, (DataView)dataView){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ DataView val$dataView;
            {
                this.val$dataView = dataView;
                super(x0, x1, x2);
            }

            protected void onSortChanged() {
                this.val$dataView.setCurrentPage(0);
            }
        };
    }

    private static class SortableRepositoriesProvider
    extends SortableDataProvider<RepositoryModel> {
        private static final long serialVersionUID = 1L;
        private List<RepositoryModel> list;

        protected SortableRepositoriesProvider(List<RepositoryModel> list) {
            this.list = list;
            this.setSort(SortBy.date.name(), false);
        }

        public int size() {
            if (this.list == null) {
                return 0;
            }
            return this.list.size();
        }

        public IModel<RepositoryModel> model(RepositoryModel header) {
            return new Model((Serializable)header);
        }

        public Iterator<RepositoryModel> iterator(int first, int count) {
            SortParam sp = this.getSort();
            String prop = sp.getProperty();
            final boolean asc = sp.isAscending();
            if (prop == null || prop.equals(SortBy.date.name())) {
                Collections.sort(this.list, new Comparator<RepositoryModel>(){

                    @Override
                    public int compare(RepositoryModel o1, RepositoryModel o2) {
                        if (asc) {
                            return o1.lastChange.compareTo(o2.lastChange);
                        }
                        return o2.lastChange.compareTo(o1.lastChange);
                    }
                });
            } else if (prop.equals(SortBy.repository.name())) {
                Collections.sort(this.list, new Comparator<RepositoryModel>(){

                    @Override
                    public int compare(RepositoryModel o1, RepositoryModel o2) {
                        if (asc) {
                            return o1.name.compareTo(o2.name);
                        }
                        return o2.name.compareTo(o1.name);
                    }
                });
            } else if (prop.equals(SortBy.owner.name())) {
                Collections.sort(this.list, new Comparator<RepositoryModel>(){

                    @Override
                    public int compare(RepositoryModel o1, RepositoryModel o2) {
                        String own1 = ArrayUtils.toString(o1.owners);
                        String own2 = ArrayUtils.toString(o2.owners);
                        if (asc) {
                            return own1.compareTo(own2);
                        }
                        return own2.compareTo(own1);
                    }
                });
            } else if (prop.equals(SortBy.description.name())) {
                Collections.sort(this.list, new Comparator<RepositoryModel>(){

                    @Override
                    public int compare(RepositoryModel o1, RepositoryModel o2) {
                        if (asc) {
                            return o1.description.compareTo(o2.description);
                        }
                        return o2.description.compareTo(o1.description);
                    }
                });
            }
            return this.list.subList(first, first + count).iterator();
        }
    }

    protected static enum SortBy {
        repository,
        description,
        owner,
        date;

    }

    private static class GroupRepositoryModel
    extends RepositoryModel {
        private static final long serialVersionUID = 1L;
        int count;
        String title;

        GroupRepositoryModel(String name, int count) {
            super(name, "", "", new Date(0L));
            this.count = count;
        }

        @Override
        public String toString() {
            return (StringUtils.isEmpty(this.title) ? this.name : this.title) + " (" + this.count + ")";
        }
    }

    private static enum CollapsibleRepositorySetting {
        DISABLED,
        EXPANDED,
        COLLAPSED;


        public static CollapsibleRepositorySetting get(String name) {
            CollapsibleRepositorySetting returnVal = DISABLED;
            for (CollapsibleRepositorySetting setting : CollapsibleRepositorySetting.values()) {
                if (!setting.name().equalsIgnoreCase(name)) continue;
                returnVal = setting;
                break;
            }
            return returnVal;
        }
    }
}

