/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.models.ProjectModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.panels.BasePanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class RepositoryNamePanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private String fullName;
    private final IModel<String> projectPath;
    private DropDownChoice<String> pathChoice;
    private final IModel<String> repoName;
    private TextField<String> nameField;

    public RepositoryNamePanel(String wicketId, RepositoryModel repository) {
        super(wicketId);
        GitBlitWebSession session = GitBlitWebSession.get();
        UserModel user = session.getUser();
        if (user == null) {
            user = UserModel.ANONYMOUS;
        }
        String defaultPath = null;
        String defaultName = null;
        TreeSet<String> pathNames = new TreeSet<String>();
        for (ProjectModel project : this.app().projects().getProjectModels(user, false)) {
            if (!user.canAdmin()) continue;
            if (project.isRoot) {
                pathNames.add("/");
                continue;
            }
            pathNames.add(project.name + "/");
        }
        if (user.canAdmin() || user.canCreate()) {
            pathNames.add(user.getPersonalPath() + "/");
        }
        if (!StringUtils.isEmpty(repository.name)) {
            if (StringUtils.isEmpty(repository.projectPath)) {
                defaultPath = "/";
                defaultName = repository.name;
            } else {
                defaultPath = repository.projectPath + "/";
                defaultName = repository.name.substring(defaultPath.length());
            }
            pathNames.add(defaultPath);
        }
        if (defaultPath == null) {
            if (user.canAdmin()) {
                defaultPath = "/";
            } else if (user.canCreate()) {
                defaultPath = user.getPersonalPath() + "/";
            }
        }
        this.projectPath = Model.of(defaultPath);
        this.pathChoice = new DropDownChoice("projectPath", this.projectPath, new ArrayList(pathNames));
        this.repoName = Model.of((Serializable)((Object)defaultName));
        this.nameField = new TextField("name", this.repoName);
        this.add(new Component[]{this.pathChoice.setEnabled(pathNames.size() > 1)});
        this.add(new Component[]{this.nameField});
        this.add(new Component[]{new TextField("description")});
    }

    public void setEditable(boolean editable) {
        this.pathChoice.setEnabled(this.pathChoice.getChoices().size() > 1 && editable);
        this.nameField.setEnabled(editable);
    }

    public boolean updateModel(RepositoryModel repositoryModel) {
        if (StringUtils.isEmpty((String)this.projectPath.getObject())) {
            this.error((Serializable)((Object)this.getString("gb.pleaseSelectProject")));
            return false;
        }
        if (StringUtils.isEmpty((String)this.repoName.getObject())) {
            this.error((Serializable)((Object)this.getString("gb.pleaseSetRepositoryName")));
            return false;
        }
        String project = (String)this.projectPath.getObject();
        String name = (String)this.repoName.getObject();
        this.fullName = (project + name).trim();
        this.fullName = this.fullName.replace('\\', '/');
        this.fullName = this.fullName.replace("//", "/");
        if (this.fullName.charAt(0) == '/') {
            this.fullName = this.fullName.substring(1);
        }
        if (this.fullName.endsWith("/")) {
            this.fullName = this.fullName.substring(0, this.fullName.length() - 1);
        }
        if (this.fullName.contains("../")) {
            this.error((Serializable)((Object)this.getString("gb.illegalRelativeSlash")));
            return false;
        }
        if (this.fullName.contains("/../")) {
            this.error((Serializable)((Object)this.getString("gb.illegalRelativeSlash")));
            return false;
        }
        Character c = StringUtils.findInvalidCharacter(this.fullName);
        if (c != null) {
            this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.illegalCharacterRepositoryName"), c)));
            return false;
        }
        repositoryModel.name = this.fullName;
        return true;
    }

    protected boolean getStatelessHint() {
        return false;
    }
}

