/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.models.GitClientApplication;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.RepositoryUrl;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.ExternalImage;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.ShockWaveComponent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.ContextImage;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.request.WebClientInfo;

public class RepositoryUrlPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private final String externalPermission = "?";
    private boolean onlyUrls;
    private UserModel user;
    private RepositoryModel repository;
    private RepositoryUrl primaryUrl;
    private Map<String, String> urlPermissionsMap;
    private Map<Constants.AccessRestrictionType, String> accessRestrictionsMap;

    public RepositoryUrlPanel(String wicketId, boolean onlyUrls, UserModel user, RepositoryModel repository) {
        super(wicketId);
        this.onlyUrls = onlyUrls;
        this.user = user == null ? UserModel.ANONYMOUS : user;
        this.repository = repository;
        this.urlPermissionsMap = new HashMap<String, String>();
    }

    protected void onInitialize() {
        boolean canClone;
        super.onInitialize();
        HttpServletRequest req = ((WebRequest)this.getRequest()).getHttpServletRequest();
        List<RepositoryUrl> repositoryUrls = this.app().services().getRepositoryUrls(req, this.user, this.repository);
        this.primaryUrl = repositoryUrls.size() == 0 ? null : repositoryUrls.get(0);
        boolean bl = canClone = this.primaryUrl != null && (!this.primaryUrl.hasPermission() || this.primaryUrl.permission.atLeast(Constants.AccessPermission.CLONE));
        if (repositoryUrls.size() == 0 || !canClone) {
            this.add(new Component[]{new Label("repositoryUrlPanel").setVisible(false)});
            this.add(new Component[]{new Label("applicationMenusPanel").setVisible(false)});
            this.add(new Component[]{new Label("repositoryIndicators").setVisible(false)});
            return;
        }
        this.add(new Component[]{this.createPrimaryUrlPanel("repositoryUrlPanel", this.repository, repositoryUrls)});
        if (this.onlyUrls) {
            this.add(new Component[]{new Label("repositoryIndicators").setVisible(false)});
        } else {
            this.add(new Component[]{this.createRepositoryIndicators(this.repository)});
        }
        boolean allowAppLinks = this.app().settings().getBoolean("web.allowAppCloneLinks", true);
        if (this.onlyUrls || !canClone || !allowAppLinks) {
            this.add(new Component[]{new Label("applicationMenusPanel").setVisible(false)});
            return;
        }
        this.add(new Component[]{this.createApplicationMenus("applicationMenusPanel", this.user, this.repository, repositoryUrls)});
    }

    public String getPrimaryUrl() {
        return this.primaryUrl == null ? "" : this.primaryUrl.url;
    }

    protected Fragment createPrimaryUrlPanel(String wicketId, final RepositoryModel repository, List<RepositoryUrl> repositoryUrls) {
        Fragment urlPanel = new Fragment(wicketId, "repositoryUrlFragment", (MarkupContainer)this);
        urlPanel.setRenderBodyOnly(true);
        if (repositoryUrls.size() == 1) {
            urlPanel.add(new Component[]{new Label("menu").setVisible(false)});
        } else {
            ListDataProvider urlsDp = new ListDataProvider(repositoryUrls);
            DataView<RepositoryUrl> repoUrlMenuItems = new DataView<RepositoryUrl>("repoUrls", (IDataProvider)urlsDp){
                private static final long serialVersionUID = 1L;

                public void populateItem(Item<RepositoryUrl> item) {
                    RepositoryUrl repoUrl = (RepositoryUrl)item.getModelObject();
                    Fragment fragment = new Fragment("repoUrl", "actionFragment", (MarkupContainer)this);
                    Component content = new Label("content", repoUrl.url).setRenderBodyOnly(true);
                    WicketUtils.setCssClass(content, "commandMenuItem");
                    fragment.add(new Component[]{content});
                    item.add(new Component[]{fragment});
                    Label permissionLabel = new Label("permission", repoUrl.hasPermission() ? repoUrl.permission.toString() : "?");
                    WicketUtils.setPermissionClass((Component)permissionLabel, repoUrl.permission);
                    String tooltip = RepositoryUrlPanel.this.getProtocolPermissionDescription(repository, repoUrl);
                    WicketUtils.setHtmlTooltip((Component)permissionLabel, tooltip);
                    fragment.add(new Component[]{permissionLabel});
                    fragment.add(new Component[]{RepositoryUrlPanel.this.createCopyFragment(repoUrl.url)});
                }
            };
            Fragment urlMenuFragment = new Fragment("menu", "urlProtocolMenuFragment", (MarkupContainer)this);
            urlMenuFragment.setRenderBodyOnly(true);
            urlMenuFragment.add(new Component[]{new Label("menuText", this.getString("gb.url"))});
            urlMenuFragment.add(new Component[]{repoUrlMenuItems});
            urlPanel.add(new Component[]{urlMenuFragment});
        }
        if (repository.isMirror) {
            urlPanel.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "mirror_16x16.png", this.getString("gb.isMirror"))});
        } else if (this.app().services().isServingRepositories()) {
            switch (repository.accessRestriction) {
                case NONE: {
                    urlPanel.add(new Component[]{WicketUtils.newClearPixel("accessRestrictionIcon").setVisible(false)});
                    break;
                }
                case PUSH: {
                    urlPanel.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "lock_go_16x16.png", this.getAccessRestrictions().get((Object)repository.accessRestriction))});
                    break;
                }
                case CLONE: {
                    urlPanel.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "lock_pull_16x16.png", this.getAccessRestrictions().get((Object)repository.accessRestriction))});
                    break;
                }
                case VIEW: {
                    urlPanel.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "shield_16x16.png", this.getAccessRestrictions().get((Object)repository.accessRestriction))});
                    break;
                }
                default: {
                    if (repositoryUrls.size() == 1) {
                        urlPanel.add(new Component[]{WicketUtils.newBlankIcon("accessRestrictionIcon")});
                        break;
                    }
                    urlPanel.add(new Component[]{WicketUtils.newClearPixel("accessRestrictionIcon").setVisible(false)});
                    break;
                }
            }
        } else if (repositoryUrls.size() == 1) {
            urlPanel.add(new Component[]{WicketUtils.newBlankIcon("accessRestrictionIcon")});
        } else {
            urlPanel.add(new Component[]{WicketUtils.newClearPixel("accessRestrictionIcon").setVisible(false)});
        }
        urlPanel.add(new Component[]{new Label("primaryUrl", this.primaryUrl.url).setRenderBodyOnly(true)});
        Label permissionLabel = new Label("primaryUrlPermission", this.primaryUrl.hasPermission() ? this.primaryUrl.permission.toString() : "?");
        String tooltip = this.getProtocolPermissionDescription(repository, this.primaryUrl);
        WicketUtils.setHtmlTooltip((Component)permissionLabel, tooltip);
        urlPanel.add(new Component[]{permissionLabel});
        urlPanel.add(new Component[]{this.createCopyFragment(this.primaryUrl.url)});
        return urlPanel;
    }

    protected Fragment createApplicationMenus(String wicketId, final UserModel user, final RepositoryModel repository, final List<RepositoryUrl> repositoryUrls) {
        ArrayList<GitClientApplication> displayedApps = new ArrayList<GitClientApplication>();
        String userAgent = ((WebClientInfo)GitBlitWebSession.get().getClientInfo()).getUserAgent();
        if (user.canClone(repository)) {
            for (GitClientApplication app : this.app().gitblit().getClientApplications()) {
                if (!app.isActive || !app.allowsPlatform(userAgent)) continue;
                displayedApps.add(app);
            }
        }
        final String baseURL = WicketUtils.getGitblitURL(RequestCycle.get().getRequest());
        ListDataProvider displayedAppsDp = new ListDataProvider(displayedApps);
        DataView<GitClientApplication> appMenus = new DataView<GitClientApplication>("appMenus", (IDataProvider)displayedAppsDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<GitClientApplication> item) {
                final GitClientApplication clientApp = (GitClientApplication)item.getModelObject();
                ArrayList<RepositoryUrl> urls = new ArrayList<RepositoryUrl>();
                for (RepositoryUrl repoUrl : repositoryUrls) {
                    if (clientApp.minimumPermission == null || !repoUrl.hasPermission()) {
                        if (!clientApp.supportsTransport(repoUrl.url)) continue;
                        urls.add(repoUrl);
                        continue;
                    }
                    if (!repoUrl.permission.atLeast(clientApp.minimumPermission) || !clientApp.supportsTransport(repoUrl.url)) continue;
                    urls.add(repoUrl);
                }
                if (urls.size() == 0) {
                    item.add(new Component[]{new Label("appMenu").setVisible(false)});
                    return;
                }
                Fragment appMenu = new Fragment("appMenu", "appMenuFragment", (MarkupContainer)this);
                appMenu.setRenderBodyOnly(true);
                item.add(new Component[]{appMenu});
                appMenu.add(new Component[]{new Label("applicationName", clientApp.name)});
                Object img = StringUtils.isEmpty(clientApp.icon) ? WicketUtils.newClearPixel("applicationIcon").setVisible(false) : (clientApp.icon.contains("://") ? new ExternalImage("applicationIcon", clientApp.icon) : WicketUtils.newImage("applicationIcon", clientApp.icon));
                appMenu.add(new Component[]{img});
                if (StringUtils.isEmpty(clientApp.productUrl)) {
                    appMenu.add(new Component[]{new Label("applicationTitle", clientApp.toString())});
                } else {
                    appMenu.add(new Component[]{new LinkPanel("applicationTitle", null, clientApp.toString(), clientApp.productUrl, true)});
                }
                if (StringUtils.isEmpty(clientApp.description)) {
                    appMenu.add(new Component[]{new Label("applicationDescription").setVisible(false)});
                } else {
                    appMenu.add(new Component[]{new Label("applicationDescription", clientApp.description)});
                }
                if (StringUtils.isEmpty(clientApp.legal)) {
                    appMenu.add(new Component[]{new Label("applicationLegal").setVisible(false)});
                } else {
                    appMenu.add(new Component[]{new Label("applicationLegal", clientApp.legal)});
                }
                ListDataProvider urlsDp = new ListDataProvider(urls);
                DataView<RepositoryUrl> actionItems = new DataView<RepositoryUrl>("actionItems", (IDataProvider)urlsDp){
                    private static final long serialVersionUID = 1L;

                    public void populateItem(Item<RepositoryUrl> repoLinkItem) {
                        RepositoryUrl repoUrl = (RepositoryUrl)repoLinkItem.getModelObject();
                        Fragment fragment = new Fragment("actionItem", "actionFragment", (MarkupContainer)this);
                        fragment.add(new Component[]{RepositoryUrlPanel.this.createPermissionBadge("permission", repoUrl)});
                        if (!StringUtils.isEmpty(clientApp.cloneUrl)) {
                            String url = RepositoryUrlPanel.this.substitute(clientApp.cloneUrl, repoUrl.url, baseURL, user.username, repository.name);
                            fragment.add(new Component[]{new LinkPanel("content", "applicationMenuItem", this.getString("gb.clone") + " " + repoUrl.url, url)});
                            repoLinkItem.add(new Component[]{fragment});
                            fragment.add(new Component[]{new Label("copyFunction").setVisible(false)});
                        } else if (!StringUtils.isEmpty(clientApp.command)) {
                            String command = RepositoryUrlPanel.this.substitute(clientApp.command, repoUrl.url, baseURL, user.username, repository.name);
                            Label content = new Label("content", command);
                            WicketUtils.setCssClass((Component)content, "commandMenuItem");
                            fragment.add(new Component[]{content});
                            repoLinkItem.add(new Component[]{fragment});
                            fragment.add(new Component[]{RepositoryUrlPanel.this.createCopyFragment(command)});
                        }
                    }
                };
                appMenu.add(new Component[]{actionItems});
            }
        };
        Fragment applicationMenus = new Fragment(wicketId, "applicationMenusFragment", (MarkupContainer)this);
        applicationMenus.add(new Component[]{appMenus});
        return applicationMenus;
    }

    protected String substitute(String pattern, String repoUrl, String baseUrl, String username, String repository) {
        return pattern.replace("${repoUrl}", repoUrl).replace("${baseUrl}", baseUrl).replace("${username}", username).replace("${repository}", repository);
    }

    protected Label createPermissionBadge(String wicketId, RepositoryUrl repoUrl) {
        Label permissionLabel = new Label(wicketId, repoUrl.hasPermission() ? repoUrl.permission.toString() : "?");
        WicketUtils.setPermissionClass((Component)permissionLabel, repoUrl.permission);
        String tooltip = this.getProtocolPermissionDescription(this.repository, repoUrl);
        WicketUtils.setHtmlTooltip((Component)permissionLabel, tooltip);
        return permissionLabel;
    }

    protected Fragment createCopyFragment(String text) {
        if (this.app().settings().getBoolean("web.allowFlashCopyToClipboard", true)) {
            Fragment copyFragment = new Fragment("copyFunction", "clippyPanel", (MarkupContainer)this);
            String baseUrl = WicketUtils.getGitblitURL(this.getRequest());
            ShockWaveComponent clippy = new ShockWaveComponent("clippy", baseUrl + "/clippy.swf");
            clippy.setValue("flashVars", "text=" + StringUtils.encodeURL(text));
            copyFragment.add(new Component[]{clippy});
            return copyFragment;
        }
        Fragment copyFragment = new Fragment("copyFunction", "jsPanel", (MarkupContainer)this);
        ContextImage img = WicketUtils.newImage("copyIcon", "clippy.png");
        img.add(new IBehavior[]{new BasePanel.JavascriptTextPrompt("onclick", "Copy to Clipboard (Ctrl+C, Enter)", text)});
        copyFragment.add(new Component[]{img});
        return copyFragment;
    }

    protected String getProtocolPermissionDescription(RepositoryModel repository, RepositoryUrl repoUrl) {
        if (!this.urlPermissionsMap.containsKey(repoUrl.url)) {
            String note;
            if (repoUrl.hasPermission()) {
                String key;
                note = null;
                switch (repoUrl.permission) {
                    case OWNER: 
                    case REWIND: {
                        key = "gb.rewindPermission";
                        break;
                    }
                    case DELETE: {
                        key = "gb.deletePermission";
                        break;
                    }
                    case CREATE: {
                        key = "gb.createPermission";
                        break;
                    }
                    case PUSH: {
                        key = "gb.pushPermission";
                        break;
                    }
                    case CLONE: {
                        key = "gb.clonePermission";
                        break;
                    }
                    default: {
                        key = null;
                        note = this.getString("gb.viewAccess");
                    }
                }
                if (note == null) {
                    String description;
                    String pattern = this.getString(key);
                    note = description = MessageFormat.format(pattern, repoUrl.permission.toString());
                }
            } else {
                int protocolIndex = repoUrl.url.indexOf("://");
                String protocol = protocolIndex > -1 ? repoUrl.url.substring(0, protocolIndex) : "ssh";
                note = MessageFormat.format(this.getString("gb.externalPermissions"), protocol);
            }
            this.urlPermissionsMap.put(repoUrl.url, note);
        }
        return this.urlPermissionsMap.get(repoUrl.url);
    }

    protected Map<Constants.AccessRestrictionType, String> getAccessRestrictions() {
        if (this.accessRestrictionsMap == null) {
            this.accessRestrictionsMap = new HashMap<Constants.AccessRestrictionType, String>();
            block6: for (Constants.AccessRestrictionType type : Constants.AccessRestrictionType.values()) {
                switch (type) {
                    case NONE: {
                        this.accessRestrictionsMap.put(type, this.getString("gb.notRestricted"));
                        continue block6;
                    }
                    case PUSH: {
                        this.accessRestrictionsMap.put(type, this.getString("gb.pushRestricted"));
                        continue block6;
                    }
                    case CLONE: {
                        this.accessRestrictionsMap.put(type, this.getString("gb.cloneRestricted"));
                        continue block6;
                    }
                    case VIEW: {
                        this.accessRestrictionsMap.put(type, this.getString("gb.viewRestricted"));
                    }
                }
            }
        }
        return this.accessRestrictionsMap;
    }

    protected Component createRepositoryIndicators(RepositoryModel repository) {
        Fragment fragment = new Fragment("repositoryIndicators", "indicatorsFragment", (MarkupContainer)this);
        if (repository.isBare) {
            fragment.add(new Component[]{new Label("workingCopyIndicator").setVisible(false)});
        } else {
            Fragment wc = new Fragment("workingCopyIndicator", "workingCopyFragment", (MarkupContainer)this);
            Label lbl = new Label("workingCopy", this.getString("gb.workingCopy"));
            WicketUtils.setHtmlTooltip((Component)lbl, this.getString("gb.workingCopyWarning"));
            wc.add(new Component[]{lbl});
            fragment.add(new Component[]{wc});
        }
        boolean allowForking = this.app().settings().getBoolean("web.allowForking", true);
        if (!allowForking || this.user == null || !this.user.isAuthenticated) {
            fragment.add(new Component[]{new Label("forksProhibitedIndicator").setVisible(false)});
        } else {
            String fork = this.app().repositories().getFork(this.user.username, repository.name);
            boolean hasFork = fork != null;
            boolean canFork = this.user.canFork(repository);
            if (hasFork || !canFork) {
                if (this.user.canFork() && !repository.allowForks) {
                    Fragment wc = new Fragment("forksProhibitedIndicator", "forksProhibitedFragment", (MarkupContainer)this);
                    Label lbl = new Label("forksProhibited", this.getString("gb.forksProhibited"));
                    WicketUtils.setHtmlTooltip((Component)lbl, this.getString("gb.forksProhibitedWarning"));
                    wc.add(new Component[]{lbl});
                    fragment.add(new Component[]{wc});
                } else {
                    fragment.add(new Component[]{new Label("forksProhibitedIndicator").setVisible(false)});
                }
            } else if (canFork) {
                fragment.add(new Component[]{new Label("forksProhibitedIndicator").setVisible(false)});
            }
        }
        return fragment;
    }
}

