/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.models.RefModel;
import com.gitblit.servlet.RawServlet;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BlobPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.LogPage;
import com.gitblit.wicket.pages.TagPage;
import com.gitblit.wicket.pages.TagsPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.eclipse.jgit.lib.Repository;

public class TagsPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private final boolean hasTags;

    public TagsPanel(String wicketId, final String repositoryName, Repository r, int maxCount) {
        super(wicketId);
        List<RefModel> tags = JGitUtils.getTags(r, false, maxCount);
        if (maxCount > 0) {
            this.add(new Component[]{new LinkPanel("header", "title", (IModel<String>)new StringResourceModel("gb.tags", (Component)this, null), TagsPage.class, WicketUtils.newRepositoryParameter(repositoryName))});
        } else {
            this.add(new Component[]{new Label("header", (IModel)new StringResourceModel("gb.tags", (Component)this, null))});
        }
        ListDataProvider tagsDp = new ListDataProvider(tags);
        DataView<RefModel> tagView = new DataView<RefModel>("tag", (IDataProvider)tagsDp){
            private static final long serialVersionUID = 1L;
            int counter;

            public void populateItem(Item<RefModel> item) {
                Class linkClass;
                RefModel entry = (RefModel)item.getModelObject();
                item.add(new Component[]{WicketUtils.createDateLabel("tagDate", entry.getDate(), TagsPanel.this.getTimeZone(), TagsPanel.this.getTimeUtils())});
                switch (entry.getReferencedObjectType()) {
                    case 3: {
                        linkClass = BlobPage.class;
                        break;
                    }
                    case 2: {
                        linkClass = TreePage.class;
                        break;
                    }
                    default: {
                        linkClass = CommitPage.class;
                    }
                }
                item.add(new Component[]{new LinkPanel("tagName", "list name", entry.displayName, linkClass, WicketUtils.newObjectParameter(repositoryName, entry.getReferencedObjectId().getName()))});
                String message = StringUtils.trimString(entry.getShortMessage(), 78);
                if (linkClass.equals(BlobPage.class)) {
                    item.add(new Component[]{WicketUtils.newImage("tagIcon", "file_16x16.png")});
                    LinkPanel messageLink = new LinkPanel("tagDescription", "list", message, TagPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getObjectId().getName()));
                    if (!entry.getShortMessage().equals(message)) {
                        messageLink.setTooltip(entry.getShortMessage());
                    }
                    item.add(new Component[]{messageLink});
                    Fragment fragment = new Fragment("tagLinks", "blobLinks", (MarkupContainer)this);
                    fragment.add(new Component[]{new BookmarkablePageLink("tag", TagPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getObjectId().getName())).setEnabled(entry.isAnnotatedTag())});
                    fragment.add(new Component[]{new BookmarkablePageLink("blob", linkClass, WicketUtils.newObjectParameter(repositoryName, entry.getReferencedObjectId().getName()))});
                    String contextUrl = RequestCycle.get().getRequest().getRelativePathPrefixToContextRoot();
                    String rawUrl = RawServlet.asLink(contextUrl, repositoryName, entry.displayName, entry.getReferencedObjectId().getName());
                    fragment.add(new Component[]{new ExternalLink("raw", rawUrl)});
                    item.add(new Component[]{fragment});
                } else if (entry.isAnnotatedTag()) {
                    item.add(new Component[]{WicketUtils.newImage("tagIcon", "tag_16x16.png")});
                    LinkPanel messageLink = new LinkPanel("tagDescription", "list", message, TagPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getObjectId().getName()));
                    if (!message.equals(entry.getShortMessage())) {
                        messageLink.setTooltip(entry.getShortMessage());
                    }
                    item.add(new Component[]{messageLink});
                    Fragment fragment = new Fragment("tagLinks", "annotatedLinks", (MarkupContainer)this);
                    fragment.add(new Component[]{new BookmarkablePageLink("tag", TagPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getObjectId().getName())).setEnabled(entry.isAnnotatedTag())});
                    fragment.add(new Component[]{new BookmarkablePageLink("commit", linkClass, WicketUtils.newObjectParameter(repositoryName, entry.getReferencedObjectId().getName()))});
                    fragment.add(new Component[]{new BookmarkablePageLink("log", LogPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()))});
                    item.add(new Component[]{fragment});
                } else {
                    item.add(new Component[]{WicketUtils.newBlankImage("tagIcon")});
                    item.add(new Component[]{new LinkPanel("tagDescription", "list", message, CommitPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getObjectId().getName()))});
                    Fragment fragment = new Fragment("tagLinks", "lightweightLinks", (MarkupContainer)this);
                    fragment.add(new Component[]{new BookmarkablePageLink("commit", CommitPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getReferencedObjectId().getName()))});
                    fragment.add(new Component[]{new BookmarkablePageLink("log", LogPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()))});
                    item.add(new Component[]{fragment});
                }
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{tagView});
        if (tags.size() < maxCount || maxCount <= 0) {
            this.add(new Component[]{new Label("allTags", "").setVisible(false)});
        } else {
            this.add(new Component[]{new LinkPanel("allTags", "link", (IModel<String>)new StringResourceModel("gb.allTags", (Component)this, null), TagsPage.class, WicketUtils.newRepositoryParameter(repositoryName))});
        }
        this.hasTags = tags.size() > 0;
    }

    public TagsPanel hideIfEmpty() {
        this.setVisible(this.hasTags);
        return this;
    }
}

