/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.SessionlessForm;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.target.basic.RedirectRequestTarget;

public class TicketSearchForm
extends SessionlessForm<Void>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String repositoryName;
    private final IModel<String> searchBoxModel;

    public TicketSearchForm(String id, String repositoryName, String text, Class<? extends BasePage> pageClass, PageParameters params) {
        super(id, pageClass, params);
        this.repositoryName = repositoryName;
        this.searchBoxModel = new Model((Serializable)((Object)(text == null ? "" : text)));
        TextField searchBox = new TextField("ticketSearchBox", this.searchBoxModel);
        this.add(new Component[]{searchBox});
    }

    protected void onInitialize() {
        super.onInitialize();
        WicketUtils.setHtmlTooltip(this.get("ticketSearchBox"), MessageFormat.format(this.getString("gb.searchTicketsTooltip"), ""));
        WicketUtils.setInputPlaceholder(this.get("ticketSearchBox"), this.getString("gb.searchTickets"));
    }

    public void onSubmit() {
        String searchString = (String)this.searchBoxModel.getObject();
        if (StringUtils.isEmpty(searchString)) {
            String absoluteUrl = this.getAbsoluteUrl();
            this.getRequestCycle().setRequestTarget((IRequestTarget)new RedirectRequestTarget(absoluteUrl));
            return;
        }
        PageParameters params = WicketUtils.newRepositoryParameter(this.repositoryName);
        params.add("s", searchString);
        String absoluteUrl = this.getAbsoluteUrl(this.pageClass, params);
        this.getRequestCycle().setRequestTarget((IRequestTarget)new RedirectRequestTarget(absoluteUrl));
    }
}

