/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.bugtraq;

import com.syntevo.bugtraq.BugtraqConfig;
import com.syntevo.bugtraq.BugtraqEntry;
import com.syntevo.bugtraq.BugtraqParserIssueId;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public final class BugtraqFormatter {
    private final BugtraqConfig config;

    public BugtraqFormatter(@NotNull BugtraqConfig config) {
        this.config = config;
    }

    public void formatLogMessage(@NotNull String message, @NotNull OutputHandler outputHandler) {
        TreeSet<IssueId> allIds = new TreeSet<IssueId>(new Comparator<IssueId>(){

            @Override
            public int compare(IssueId o1, IssueId o2) {
                int from2;
                int from1 = o1.id.getFrom();
                return from1 > (from2 = o2.id.getFrom()) ? 1 : (from1 < from2 ? -1 : 0);
            }
        });
        for (BugtraqEntry entry : this.config.getEntries()) {
            List<BugtraqParserIssueId> ids = entry.getParser().parse(message);
            for (BugtraqParserIssueId id : ids) {
                allIds.add(new IssueId(entry, id));
            }
        }
        int lastIdEnd = -1;
        for (IssueId issueId : allIds) {
            BugtraqParserIssueId id = issueId.id;
            if (id.getFrom() <= lastIdEnd) continue;
            BugtraqFormatter.appendText(message.substring(lastIdEnd + 1, id.getFrom()), outputHandler);
            String logLinkText = issueId.entry.getLogLinkText();
            String linkText = logLinkText != null ? logLinkText.replace("%BUGID%", id.getId()) : message.substring(id.getFrom(), id.getTo() + 1);
            String target = issueId.entry.getUrl().replace("%BUGID%", id.getId());
            outputHandler.appendLink(linkText, target);
            lastIdEnd = id.getTo();
        }
        if (lastIdEnd - 1 < message.length()) {
            BugtraqFormatter.appendText(message.substring(lastIdEnd + 1, message.length()), outputHandler);
        }
    }

    private static void appendText(@NotNull String message, @NotNull OutputHandler outputHandler) {
        if (message.length() == 0) {
            return;
        }
        outputHandler.appendText(message);
    }

    private static class IssueId {
        private final BugtraqEntry entry;
        private final BugtraqParserIssueId id;

        private IssueId(BugtraqEntry entry, BugtraqParserIssueId id) {
            this.entry = entry;
            this.id = id;
        }
    }

    public static interface OutputHandler {
        public void appendText(@NotNull String var1);

        public void appendLink(@NotNull String var1, @NotNull String var2);
    }
}

